package coreservlets;

import javax.servlet.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;
import java.text.*;

/** Znacznik zwraca warto licznika.
 *  Dla aplikacji boats.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class CounterTag extends TagSupport {
  public int doStartTag() {
    try {
      ServletContext application =
        pageContext.getServletContext();
      Count count = (Count)application.getAttribute("count");
      if (count == null) {
        count = new Count();
        application.setAttribute("count", count);
      }
      DateFormat formatter =
        DateFormat.getDateInstance(DateFormat.MEDIUM);
      JspWriter out = pageContext.getOut();
      out.println("<BR CLEAR=\"ALL\"><BR><HR>");
      out.println("Strona odczytana " +
                  count.getCount() + " razy od " +
                  formatter.format(count.getStartDate()) +
                  ".");
      count.incrementCount();
    } catch(IOException ioe) {
      System.out.println("Bd w znaczniku CounterTag: " + ioe);
    }
    return(SKIP_BODY);
  }
}
